%% paste data
hsi = [];
open hsi


%% write down the haar matrix
% you can simply write down or use any creative method you like
H = [...
kron(eye(8,8), [1,-1])/sqrt(2)
kron(eye(4,4), kron([1,-1], ones(1,2)))/sqrt(4)
kron(eye(2,2), kron([1,-1], ones(1,4)))/sqrt(8)
kron([1,-1], ones(1,8))/sqrt(16)
ones(1,16)/sqrt(16)];

%% do the decomposition and plot them out
c = H*reshape(hsi,16,[]);

subplot(5,1,1)
plot(reshape(H(1:8,:)'*c(1:8,:), [], 1))
title('q_3')
subplot(5,1,2)
plot(reshape(H(9:12,:)'*c(9:12,:), [], 1))
title('q_2')
subplot(5,1,3)
plot(reshape(H(13:14,:)'*c(13:14,:), [], 1))
title('q_1')
subplot(5,1,4)
plot(reshape(H(15,:)'*c(15,:), [], 1))
title('q_0')
subplot(5,1,5)
plot(reshape(H(16,:)'*c(16,:), [], 1))
title('r')
